//
//  CMS_Preferences.swift
//  Composr Mobile SDK
//
//  Created by Aaswini on 06/08/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//
/*
 
 CMS_Preferences
 
 string get_value - gets an ad-hoc preference value
 set_value(string name, string value) - sets an ad-hoc preference value

 */
import UIKit
import Foundation
class CMS_Preferences: NSObject {
    
    /**
     *  Gets string value for a key from userdefaults
     *
     *  @param name Key key to check from defaults
     *
     *  @return string value for the supplied key in userdefaults
     */
    class func get_value(name: String) -> String {
        return NSUserDefaults.standardUserDefaults().objectForKey(name)!
    }
    
    /**
     *  Saves a value mapped to a key in user defaults
     *
     *  @param name  key key to which value is to be mapped
     *  @param value value to be saved
     */
    class func set_value(name: String, value: String) {
        NSUserDefaults.standardUserDefaults().setObject(value, forKey: name)
    }
}